import { transformListUsersResult } from "../lib/transformers";

export type TransformedListUserResult = ReturnType<typeof transformListUsersResult>

export type TransformedPendingUsers = NonNullable<TransformedListUserResult>["pending"]
export type TransformedVerifiedUsers = NonNullable<TransformedListUserResult>["verified"]

export type TransformedPendingUser = NonNullable<TransformedListUserResult>["pending"][number]
export type TransformedVerifiedUser = NonNullable<TransformedListUserResult>["verified"][number]

export type TransformedUsers = TransformedPendingUsers | TransformedVerifiedUsers
export type TransformedUser = TransformedPendingUser | TransformedVerifiedUser
